package ru.yandex.direct.internaltools.tools.feature.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.container.ChiefRepresentativeWithClientFeature;
import ru.yandex.direct.core.entity.feature.service.FeatureManagingService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsClientFeature;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureConverter;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureIdsState;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureConverter.toFeatureState;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Tool(
        name = "Список клиентов с доступом к фиче",
        label = "get_clients_for_features",
        description = "Получение списка клиентов с явно включенным или выключенным доступом к фиче",
        consumes = InternalToolsFeatureIdsState.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPERREADER})
public class GetFeaturesClientsTool extends MassInternalTool<InternalToolsFeatureIdsState, InternalToolsClientFeature> {
    @Autowired
    private FeatureManagingService clientFeatureService;

    @Override
    protected List<InternalToolsClientFeature> getMassData(InternalToolsFeatureIdsState parameter) {
        Result<Map<Long, List<ChiefRepresentativeWithClientFeature>>>
                operationResult =
                clientFeatureService.getFeaturesClients(Collections.singletonList(parameter.getFeatureTextId()),
                        toFeatureState(parameter.getState()));
        if (hasValidationIssues(operationResult)) {
            throw new InternalToolValidationException("").withValidationResult(operationResult.getValidationResult());
        }
        @SuppressWarnings("OptionalGetWithoutIsPresent")
        List<ChiefRepresentativeWithClientFeature> chiefRepresentativeWithClientFeatures =
                EntryStream.of(operationResult.getResult()).values().findAny().orElse(new ArrayList<>());
        return mapList(chiefRepresentativeWithClientFeatures, InternalToolsFeatureConverter::toInternalToolsClientFeature);
    }

    @Override
    public ValidationResult<InternalToolsFeatureIdsState, Defect> validate(
            InternalToolsFeatureIdsState internalToolsFeatureIdsState) {
        ItemValidationBuilder<InternalToolsFeatureIdsState, Defect> validationBuilder =
                ItemValidationBuilder.of(internalToolsFeatureIdsState);
        validationBuilder.check(notNull());
        validationBuilder.item(internalToolsFeatureIdsState.getFeatureTextId(), InternalToolsFeatureIdsState.ID)
                .check(notNull());

        return validationBuilder.getResult();
    }
}
