package ru.yandex.direct.internaltools.tools.freelancer.container;

import java.util.Map;
import java.util.StringJoiner;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.internaltools.tools.freelancer.model.IntToolCardModeration;

public class IntToolCardModerationConverter {
    public static IntToolCardModeration convertCardToIntToolParameter(
            FreelancerCard card,
            Map<Long, String> loginByClientId,
            Map<Long, String> namesByClientId,
            Map<Long, String> avatarUrlByClientId) {
        IntToolCardModeration param = new IntToolCardModeration();
        Long freelancerId = card.getFreelancerId();
        param.setClientId(freelancerId);
        param.setLogin(loginByClientId.get(freelancerId));
        param.setName(namesByClientId.get(freelancerId));
        param.setCardId(card.getId());
        param.setAvatarUrl(avatarUrlByClientId.get(freelancerId));
        param.setBrief(card.getBriefInfo());
        param.setSiteUrl(card.getContacts().getSiteUrl());
        param.setStatus(cardStatusToString(card));
        return param;
    }

    private static String cardStatusToString(FreelancerCard card) {
        if (card.getDeclineReason().isEmpty()) {
            return card.getStatusModerate().name();
        }
        StringJoiner stringJoiner = new StringJoiner(", ", " (", ")");
        card.getDeclineReason().forEach(reason ->
                stringJoiner.add(reason.name()));
        return card.getStatusModerate().name() + stringJoiner.toString();
    }
}
