package ru.yandex.direct.internaltools.tools.freelancer.container;

import java.util.Set;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCardModeration;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerFeedback;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardDeclineReason;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate;
import ru.yandex.direct.internaltools.tools.freelancer.model.CardModerationParameters;
import ru.yandex.direct.internaltools.tools.freelancer.model.IntToolFeedbackModeration;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public class IntToolFeedbackModerationConverter {

    public static IntToolFeedbackModeration convertToIntToolFeedbackModeration(FreelancerFeedback feedback) {
        String updatedTime = feedback.getUpdatedTime() != null
                ? feedback.getUpdatedTime().toLocalDateTime().toString()
                : null;
        return new IntToolFeedbackModeration()
                .withCreatedTime(feedback.getCreatedTime().toLocalDateTime().toString())
                .withUpdatedTime(updatedTime)
                .withFeedbackId(feedback.getFeedbackId())
                .withFreelancerId(feedback.getFreelancerId())
                .withAuthorUid(feedback.getAuthorUid())
                .withFeedbackText(feedback.getFeedbackText())
                .withModerationResult(feedback.getModerationStatus())
                .withDeclineReason(feedback.getDeclineReasonCode());
    }

    public static FreelancerCardModeration convertToCardModerationResult(CardModerationParameters params,
                                                                         Long freelancerId) {
        FreelancersCardStatusModerate moderationStatus =
                FreelancersCardStatusModerate.valueOf(params.getModerationResult());
        Set<FreelancersCardDeclineReason> declineReason = nvl(params.getDeclineReason(), emptySet());
        return new FreelancerCard()
                .withId(params.getCardId())
                .withFreelancerId(freelancerId)
                .withStatusModerate(moderationStatus)
                .withDeclineReason(declineReason);
    }
}
