package ru.yandex.direct.internaltools.tools.freelancer.container;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerSkill;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerSkillOffer;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerSkillOfferDuration;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.internaltools.core.exception.InternalToolProcessingException;
import ru.yandex.direct.internaltools.tools.freelancer.model.FreelancerSkillOfferDurationParameters;
import ru.yandex.direct.internaltools.tools.freelancer.model.IntToolSkillOfferChange;
import ru.yandex.direct.internaltools.tools.freelancer.model.IntToolSkillOfferView;

import static com.google.common.base.Preconditions.checkState;

public class IntToolFreelanceSkillConverter {

    private static final String SKILL_ID_SEPARATOR = " | ";

    private IntToolFreelanceSkillConverter() {
    }

    public static FreelancerSkillOffer toFreelancerSkillOffer(IntToolSkillOfferChange intToolNewSkillOffer) {
        long skillId = stringToFreelancerSkillId(intToolNewSkillOffer.getStrSkillId());
        return new FreelancerSkillOffer()
                .withFreelancerId(intToolNewSkillOffer.getFreelancerId())
                .withSkillId(skillId)
                .withPrice(BigDecimal.valueOf(intToolNewSkillOffer.getPrice()))
                .withDuration(convertFreelancerSkillOfferDurationFromIntTool(intToolNewSkillOffer.getDuration()));
    }

    public static String freelancerSkillToString(FreelancerSkill freelancerSkill) {
        return Long.toString(freelancerSkill.getSkillId())
                + SKILL_ID_SEPARATOR + freelancerSkill.getSkillCode()
                + SKILL_ID_SEPARATOR + freelancerSkill.getDescription();
    }

    public static long stringToFreelancerSkillId(String strSkillId) {
        checkState(strSkillId.contains(SKILL_ID_SEPARATOR),
                "Ошибка в коде, неверно сформировано поле StrSkillId или не сработала валидация на пустое значение.");
        int separateIndex = strSkillId.indexOf(SKILL_ID_SEPARATOR);
        return Long.parseLong(strSkillId.substring(0, separateIndex));
    }

    public static IntToolSkillOfferView toIntToolSkillOffer(FreelancerSkillOffer freelancerSkillOffer,
                                                            CurrencyCode workCurrency) {
        Long skillId = freelancerSkillOffer.getSkillId();
        String price = freelancerSkillOffer.getPrice().toString() + " " + workCurrency.toString();
        FreelancerSkill skill = FreelancerSkill.getById(skillId);
        return new IntToolSkillOfferView()
                .withFreelancerId(freelancerSkillOffer.getFreelancerId())
                .withSkillId(skillId)
                .withSkillName(skill.getDescription())
                .withPrice(price)
                .withDuration(convertFreelancerSkillOfferDurationToString(freelancerSkillOffer.getDuration()));
    }

    private static FreelancerSkillOfferDuration convertFreelancerSkillOfferDurationFromIntTool(
            FreelancerSkillOfferDurationParameters duration) {
        if (duration == null) {
            return FreelancerSkillOfferDuration.NOT_DEFINED;
        }
        try {
            return FreelancerSkillOfferDuration.valueOf(duration.name());
        } catch (IllegalArgumentException e) {
            throw new InternalToolProcessingException("Unexpected service time: " + duration);
        }
    }

    private static String convertFreelancerSkillOfferDurationToString(FreelancerSkillOfferDuration duration) {
        if (duration == null) {
            return "";
        }
        try {
            return FreelancerSkillOfferDurationParameters.valueOf(duration.name()).getDescription();
        } catch (IllegalArgumentException e) {
            throw new InternalToolProcessingException("Unexpected service time: " + duration);
        }
    }
}
