package ru.yandex.direct.internaltools.tools.freelancer.model;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardDeclineReason;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.MultipleSelect;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CardModerationParameters extends InternalToolParameter {

    public static final String FREELANCER_ID = "freelancerId";
    public static final String FREELANCER_LOGIN = "freelancerLogin";
    public static final String CARD_ID = "cardId";
    public static final String MODERATION_RESULT = "Результат модерации";
    public static final String DECLINE_REASON = "Причина отклонения карточки";

    private static final String MODERATION_ACCEPTED = "ACCEPTED";
    private static final String MODERATION_DECLINED = "DECLINED";

    @NumericId
    @Input(label = FREELANCER_ID, required = false)
    private Long freelancerId;

    @Text
    @Input(label = FREELANCER_LOGIN, required = false)
    private String freelancerLogin;

    @Text
    @Input(label = CARD_ID, required = false)
    private Long cardId;

    @Text
    @Select(choices = {MODERATION_ACCEPTED, MODERATION_DECLINED}, defaultValue = MODERATION_ACCEPTED)
    @Input(label = MODERATION_RESULT, required = false)
    private String moderationResult;

    @Text
    @MultipleSelect
    @Input(label = DECLINE_REASON, required = false)
    private Set<FreelancersCardDeclineReason> declineReason;

    public Long getFreelancerId() {
        return freelancerId;
    }

    public void setFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
    }

    public Long getCardId() {
        return cardId;
    }

    public void setCardId(Long cardId) {
        this.cardId = cardId;
    }

    public String getModerationResult() {
        return moderationResult;
    }

    public void setModerationResult(String moderationResult) {
        this.moderationResult = moderationResult;
    }

    public Set<FreelancersCardDeclineReason> getDeclineReason() {
        return declineReason;
    }

    public void setDeclineReason(Set<FreelancersCardDeclineReason> declineReason) {
        this.declineReason = declineReason;
    }

    public String getFreelancerLogin() {
        return freelancerLogin;
    }

    public void setFreelancerLogin(String freelancerLogin) {
        this.freelancerLogin = freelancerLogin;
    }
}
