package ru.yandex.direct.internaltools.tools.freelancer.model;

import java.util.StringJoiner;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Перечень просроченных сертификатов у одного конкретного фрилансера.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CertTrouble {
    @JsonProperty("FreelancerId")
    private Long id;

    @JsonProperty("FreelancerLogin")
    private String login;

    @JsonProperty("ExpiredCertTypes")
    private String expiredCertTypes;

    public Long getId() {
        return id;
    }

    public CertTrouble withId(Long id) {
        this.id = id;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public CertTrouble withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getExpiredCertTypes() {
        return expiredCertTypes;
    }

    public CertTrouble withExpiredCertTypes(String expiredCertTypes) {
        this.expiredCertTypes = expiredCertTypes;
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", CertTrouble.class.getSimpleName() + "[", "]")
                .add("id=" + id)
                .add("login='" + login + "'")
                .add("expiredCertTypes='" + expiredCertTypes + "'")
                .toString();
    }
}
