package ru.yandex.direct.internaltools.tools.freelancer.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FeedbackModerationParameters extends InternalToolParameter {

    public static final String FREELANCER_ID = "freelancerId";
    public static final String FREELANCER_LOGIN = "freelancerLogin";
    public static final String FEEDBACK_ID = "feedbackId";
    public static final String MODERATION_RESULT = "Результат модерации";
    public static final String DECLINE_REASON = "Причина отклонения модерации";

    private static final String MODERATION_ACCEPTED = "ACCEPTED";
    private static final String MODERATION_DECLINED = "DECLINED";
    private static final String DECLINE_BY_OBSCENE = "OBSCENE";
    private static final String DECLINE_BY_PERSONAL_DATA = "PERSONAL_DATA";
    private static final String DECLINE_BY_TOO_SHORT = "TOO_SHORT";
    private static final String DECLINE_BY_WRONG_LANG = "WRONG_LANG";
    private static final String DECLINE_BY_NOT_OPINION = "NOT_OPINION";
    private static final String DECLINE_BY_UPPERCASE = "UPPERCASE";

    @NumericId
    @Input(label = FREELANCER_ID, required = false)
    private Long freelancerId;

    @Text
    @Input(label = FREELANCER_LOGIN, required = false)
    private String freelancerLogin;

    @Text
    @Input(label = FEEDBACK_ID, required = false)
    private String feedbackId;

    @Text
    @Select(choices = {MODERATION_ACCEPTED, MODERATION_DECLINED}, defaultValue = MODERATION_ACCEPTED)
    @Input(label = MODERATION_RESULT, required = false)
    private String moderationResult;

    @Text
    @Select(choices = {
            DECLINE_BY_OBSCENE,
            DECLINE_BY_PERSONAL_DATA,
            DECLINE_BY_TOO_SHORT,
            DECLINE_BY_WRONG_LANG,
            DECLINE_BY_NOT_OPINION,
            DECLINE_BY_UPPERCASE})
    @Input(label = DECLINE_REASON, required = false)
    private String declineReason;

    public Long getFreelancerId() {
        return freelancerId;
    }

    public void setFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
    }

    public String getFeedbackId() {
        return feedbackId;
    }

    public void setFeedbackId(String feedbackId) {
        this.feedbackId = feedbackId;
    }

    public String getModerationResult() {
        return moderationResult;
    }

    public void setModerationResult(String moderationResult) {
        this.moderationResult = moderationResult;
    }

    public String getDeclineReason() {
        return declineReason;
    }

    public void setDeclineReason(String declineReason) {
        this.declineReason = declineReason;
    }

    public String getFreelancerLogin() {
        return freelancerLogin;
    }

    public void setFreelancerLogin(String freelancerLogin) {
        this.freelancerLogin = freelancerLogin;
    }
}
