package ru.yandex.direct.internaltools.tools.freelancer.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FreelancerRegisterParameters extends InternalToolParameter {
    @Text
    @Input(label = "Логин")
    private String login;

    @Text
    @Input(label = "Логин для сертификатов")
    private String certLogin;

    @Text
    @Input(label = "Email")
    private String email;

    @Text
    @Input(label = "Имя")
    private String firstName;

    @Text
    @Input(label = "Фамилия")
    private String secondName;

    @Text
    @Input(label = "Начальный рейтинг")
    private String initialRating;

    private String currentHost;

    private Client client;

    private Long certUid;

    public Client getClient() {
        return client;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSecondName() {
        return secondName;
    }

    public void setSecondName(String secondName) {
        this.secondName = secondName;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getCertLogin() {
        return certLogin;
    }

    public void setCertLogin(String certLogin) {
        this.certLogin = certLogin;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getInitialRating() {
        return initialRating;
    }

    public void setInitialRating(String initialRating) {
        this.initialRating = initialRating;
    }

    public String getCurrentHost() {
        return currentHost;
    }

    public void setCurrentHost(String currentHost) {
        this.currentHost = currentHost;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getLoginForCert() {
        return certLogin != null ? certLogin : login;
    }

    public Long getCertUid() {
        return certUid;
    }

    public void setCertUid(Long certUid) {
        this.certUid = certUid;
    }
}
