package ru.yandex.direct.internaltools.tools.freelancer.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.File;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FreelancerUpdateParameters extends InternalToolParameter {

    /**
     * Enum для задания видимости специалиста в списке.
     * {@link Boolean} не удобен, так как не позволяет отличить пустое значение от false
     */
    public enum Visibility {
        VISIBLE(true),
        INVISIBLE(false);

        private final boolean boolValue;

        Visibility(boolean boolValue) {
            this.boolValue = boolValue;
        }

        public boolean boolValue() {
            return boolValue;
        }
    }

    @NumericId
    @Input(label = "ClientId фрилансера")
    private Long clientId;

    @Text
    @Input(label = "Имя", required = false)
    private String firstName;

    @Text
    @Input(label = "Фамилия", required = false)
    private String secondName;

    @Input(label = "Видимость в списке", required = false)
    private Visibility visibility;

    @File
    @Input(label = "Фото", required = false)
    private byte[] avatarImage;

    @Text
    @Input(label = "Краткое описание", required = false)
    private String brief;

    @Text
    @Input(label = "Рейтинг", required = false)
    private String rating;

    @Text
    @Input(label = "ID сертификата Яндекс.Директ (введи 0, чтобы убрать сертификат)", required = false)
    private Long directCertId;

    @Text
    @Input(label = "ID сертификата Яндекс.Метрика (введи 0, чтобы убрать сертификат)", required = false)
    private Long metrikaCertId;

    @Text
    @Input(label = "Логин для сертификатов", required = false)
    private String certLogin;

    @Text
    @Input(label = "id региона", required = false)
    private Long regionId;

    @Text
    @Input(label = "Город", required = false)
    private String town;

    @Text
    @Input(label = "Email", required = false)
    private String email;

    @Text
    @Input(label = "Телефон", required = false)
    private String phone;

    @Text
    @Input(label = "Сайт (введи пробел, чтобы очистить поле)", required = false)
    private String siteUrl;

    @Text
    @Input(label = "ICQ (UIN) (введи пробел, чтобы очистить поле)", required = false)
    private String icq;

    @Text
    @Input(label = "WhatsApp (номер телефона) (введи пробел, чтобы очистить поле)", required = false)
    private String whatsApp;

    @Text
    @Input(label = "Telegram (login) (введи пробел, чтобы очистить поле)", required = false)
    private String telegram;

    @Text
    @Input(label = "Skype (login) (введи пробел, чтобы очистить поле)", required = false)
    private String skype;

    @Text
    @Input(label = "Viber (номер телефона) (введи пробел, чтобы очистить поле)", required = false)
    private String viber;

    public Long getClientId() {
        return clientId;
    }

    public FreelancerUpdateParameters setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public FreelancerUpdateParameters setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getSecondName() {
        return secondName;
    }

    public FreelancerUpdateParameters setSecondName(String secondName) {
        this.secondName = secondName;
        return this;
    }

    public Visibility getVisibility() {
        return visibility;
    }

    public FreelancerUpdateParameters setVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public byte[] getAvatarImage() {
        return avatarImage;
    }

    public FreelancerUpdateParameters setAvatarImage(byte[] avatarImage) {
        this.avatarImage = avatarImage;
        return this;
    }

    public String getBrief() {
        return brief;
    }

    public FreelancerUpdateParameters setBrief(String brief) {
        this.brief = brief;
        return this;
    }

    public String getRating() {
        return rating;
    }

    public FreelancerUpdateParameters setRating(String rating) {
        this.rating = rating;
        return this;
    }

    public Long getDirectCertId() {
        return directCertId;
    }

    public FreelancerUpdateParameters setDirectCertId(Long directCertId) {
        this.directCertId = directCertId;
        return this;
    }

    public Long getMetrikaCertId() {
        return metrikaCertId;
    }

    public FreelancerUpdateParameters setMetrikaCertId(Long metrikaCertId) {
        this.metrikaCertId = metrikaCertId;
        return this;
    }

    public String getCertLogin() {
        return certLogin;
    }

    public FreelancerUpdateParameters setCertLogin(String certLogin) {
        this.certLogin = certLogin;
        return this;
    }

    public Long getRegionId() {
        return regionId;
    }

    public FreelancerUpdateParameters setRegionId(Long regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getTown() {
        return town;
    }

    public FreelancerUpdateParameters setTown(String town) {
        this.town = town;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public FreelancerUpdateParameters setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhone() {
        return phone;
    }

    public FreelancerUpdateParameters setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getSiteUrl() {
        return siteUrl;
    }

    public FreelancerUpdateParameters setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    public String getIcq() {
        return icq;
    }

    public FreelancerUpdateParameters setIcq(String icq) {
        this.icq = icq;
        return this;
    }

    public String getWhatsApp() {
        return whatsApp;
    }

    public FreelancerUpdateParameters setWhatsApp(String whatsApp) {
        this.whatsApp = whatsApp;
        return this;
    }

    public String getTelegram() {
        return telegram;
    }

    public FreelancerUpdateParameters setTelegram(String telegram) {
        this.telegram = telegram;
        return this;
    }

    public String getSkype() {
        return skype;
    }

    public void setSkype(String skype) {
        this.skype = skype;
    }

    public String getViber() {
        return viber;
    }

    public void setViber(String viber) {
        this.viber = viber;
    }
}
