package ru.yandex.direct.internaltools.tools.freelancer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerUgcDeclineReason;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerUgcModerationStatus;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IntToolFeedbackModeration extends InternalToolParameter {
    private String createdTime;
    private String updatedTime;
    private Long freelancerId;
    private String freelancerLogin;
    @JsonIgnore // Это поле нужно для получения логина фрилансера, не отображаем
    private Long authorUid;
    private String authorLogin;
    private String feedbackId;
    private String feedbackText;
    private FreelancerUgcModerationStatus moderationStatus;
    private FreelancerUgcDeclineReason declineReason;

    public String getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getUpdatedTime() {
        return updatedTime;
    }

    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    public Long getFreelancerId() {
        return freelancerId;
    }

    public void setFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
    }

    public String getFeedbackId() {
        return feedbackId;
    }

    public void setFeedbackId(String feedbackId) {
        this.feedbackId = feedbackId;
    }

    public String getFeedbackText() {
        return feedbackText;
    }

    public void setFeedbackText(String feedbackText) {
        this.feedbackText = feedbackText;
    }

    public FreelancerUgcModerationStatus getModerationStatus() {
        return moderationStatus;
    }

    public void setModerationStatus(FreelancerUgcModerationStatus moderationStatus) {
        this.moderationStatus = moderationStatus;
    }

    public FreelancerUgcDeclineReason getDeclineReason() {
        return declineReason;
    }

    public void setDeclineReason(FreelancerUgcDeclineReason declineReason) {
        this.declineReason = declineReason;
    }

    public String getFreelancerLogin() {
        return freelancerLogin;
    }

    public void setFreelancerLogin(String freelancerLogin) {
        this.freelancerLogin = freelancerLogin;
    }

    public String getAuthorLogin() {
        return authorLogin;
    }

    public void setAuthorLogin(String authorLogin) {
        this.authorLogin = authorLogin;
    }

    public Long getAuthorUid() {
        return authorUid;
    }

    public void setAuthorUid(Long authorUid) {
        this.authorUid = authorUid;
    }

    public IntToolFeedbackModeration withCreatedTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public IntToolFeedbackModeration withUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
        return this;
    }

    public IntToolFeedbackModeration withFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
        return this;
    }

    public IntToolFeedbackModeration withFeedbackId(String feedbackId) {
        this.feedbackId = feedbackId;
        return this;
    }

    public IntToolFeedbackModeration withModerationResult(FreelancerUgcModerationStatus moderationResult) {
        this.moderationStatus = moderationResult;
        return this;
    }

    public IntToolFeedbackModeration withFeedbackText(String feedbackText) {
        this.feedbackText = feedbackText;
        return this;
    }

    public IntToolFeedbackModeration withDeclineReason(FreelancerUgcDeclineReason declineReason) {
        this.declineReason = declineReason;
        return this;
    }

    public IntToolFeedbackModeration withFreelancerLogin(String freelancerLogin) {
        this.freelancerLogin = freelancerLogin;
        return this;
    }

    public IntToolFeedbackModeration withAuthorUid(Long authorUid) {
        this.authorUid = authorUid;
        return this;
    }

    public IntToolFeedbackModeration withAuthorLogin(String authorLogin) {
        this.authorLogin = authorLogin;
        return this;
    }
}
