package ru.yandex.direct.internaltools.tools.freelancer.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.freelancer.preprocessors.FreelancersSkillNames;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class IntToolSkillOfferChange extends InternalToolParameter {

    private static final String CHANGE_SKILL_OPERATION_VALUE = "ДОБАВЛЕНИЕ ИЛИ ИЗМЕНЕНИЕ УСЛУГИ";
    public static final String DELETE_SKILL_OPERATION_VALUE = "УДАЛЕНИЕ СУЩЕСТВУЮЩЕЙ УСЛУГИ";
    private static final String FREELANCER_ID_FIELD_NAME = "FreelancerId";
    private static final String OPERATION_FIELD_NAME = "ОПЕРАЦИЯ";
    public static final String OFFER_FIELD_NAME = "Услуга";
    public static final String DATE_FIELD_NAME = "Срок выполнения";
    public static final String PRICE_FIELD_NAME = "Цена в рублях";

    @Input(label = FREELANCER_ID_FIELD_NAME)
    private Long freelancerId;
    @Input(label = OPERATION_FIELD_NAME)
    @Select(choices = {CHANGE_SKILL_OPERATION_VALUE,
            DELETE_SKILL_OPERATION_VALUE}, defaultValue = CHANGE_SKILL_OPERATION_VALUE)
    private String operation;
    @Input(label = OFFER_FIELD_NAME, required = false, processors = FreelancersSkillNames.class)
    @Select(preprocessed = true)
    private String strSkillId;

    @Input(label = DATE_FIELD_NAME, required = false)
    private FreelancerSkillOfferDurationParameters duration;

    @Input(label = PRICE_FIELD_NAME, required = false)
    private Long price;

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public FreelancerSkillOfferDurationParameters getDuration() {
        return duration;
    }

    public void setDuration(FreelancerSkillOfferDurationParameters duration) {
        this.duration = duration;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getFreelancerId() {
        return freelancerId;
    }

    public void setFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
    }

    public String getStrSkillId() {
        return strSkillId;
    }

    public void setStrSkillId(String strSkillId) {
        this.strSkillId = strSkillId;
    }
}
