package ru.yandex.direct.internaltools.tools.freelancer.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class IntToolSkillOfferView extends InternalToolParameter {
    private Long freelancerId;
    private Long skillId;
    private String skillName;
    private String duration;
    private String price;

    public Long getFreelancerId() {
        return freelancerId;
    }

    public void setFreelancerId(Long freelancerId) {
        this.freelancerId = freelancerId;
    }

    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public Long getSkillId() {
        return skillId;
    }

    public void setSkillId(Long skillId) {
        this.skillId = skillId;
    }

    public String getSkillName() {
        return skillName;
    }

    public void setSkillName(String skillName) {
        this.skillName = skillName;
    }

    public IntToolSkillOfferView withFreelancerId(Long id) {
        setFreelancerId(id);
        return this;
    }

    public IntToolSkillOfferView withSkillId(Long id) {
        setSkillId(id);
        return this;
    }

    public IntToolSkillOfferView withSkillName(String name) {
        setSkillName(name);
        return this;
    }

    public IntToolSkillOfferView withPrice(String price) {
        setPrice(price);
        return this;
    }

    public IntToolSkillOfferView withDuration(String duration) {
        setDuration(duration);
        return this;
    }
}
