package ru.yandex.direct.internaltools.tools.freelancer.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class IntoolUpdateSkill extends InternalToolParameter {

    @Text
    @Input(label = "Идентификатор навыка", required = true)
    private Long id;


    @Input(label = "Новое название навыка", required = true)
    @Text(valueMaxLen = 255)
    private String name;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    public IntoolUpdateSkill withId(Long id) {
        setId(id);
        return this;
    }

    public IntoolUpdateSkill withName(String name) {
        setName(name);
        return this;
    }


}
