package ru.yandex.direct.internaltools.tools.freelancer.preprocessors;

import java.util.List;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.freelancer.container.IntToolFreelanceSkillConverter;

import static ru.yandex.direct.core.entity.freelancer.model.FreelancerSkill.allFreelancerSkills;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class FreelancersSkillNames implements InternalToolInputPreProcessor<String> {

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> idsAndNames = mapList(allFreelancerSkills(),
                IntToolFreelanceSkillConverter::freelancerSkillToString);
        return inputBuilder
                .withAllowedValues(idsAndNames)
                .addValidator(inSet(ImmutableSet.<String>builder().addAll(idsAndNames).build()));
    }
}
