package ru.yandex.direct.internaltools.tools.freelancer.tool;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.freelancer.service.FreelancerRegisterService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Disclaimers;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException;
import ru.yandex.direct.internaltools.tools.freelancer.model.FreelancerDisableParameters;
import ru.yandex.direct.result.Result;

@Tool(
        name = "50 Отключить фрилансера",
        label = "disable_freelancer",
        description = "Отключение фрилансера с разрывом активных сотрудничеств",
        consumes = FreelancerDisableParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.TURN_OFF)
@Category(InternalToolCategory.FREELANCER)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.MANAGER,
        InternalToolAccessRole.SUPPORT})
@Disclaimers({
        "Убедись, что используешь правильный ID",
})
@ParametersAreNonnullByDefault
public class FreelancerDisableTool implements BaseInternalTool<FreelancerDisableParameters> {
    private final FreelancerRegisterService freelancerRegisterService;

    public FreelancerDisableTool(FreelancerRegisterService freelancerRegisterService) {
        this.freelancerRegisterService = freelancerRegisterService;
    }

    @Override
    public InternalToolResult process(FreelancerDisableParameters parameters) {
        Long freelancerId = parameters.getClientId();
        Long operatorUid = parameters.getOperator().getUid();
        boolean enable = parameters.getEnabled();
        Result<Long> result;
        if (enable) {
            result = freelancerRegisterService.enableFreelancer(freelancerId, operatorUid);
        } else {
            result = freelancerRegisterService.disableFreelancer(freelancerId, operatorUid);
        }
        if (!result.isSuccessful()) {
            throw new InternalToolValidationException("")
                    .withValidationResult(result.getValidationResult());
        }

        String message = "Freelancer " + freelancerId + " has been " + (enable ? "enabled" : "disabled");
        return new InternalToolResult().withMessage(message);
    }
}
