package ru.yandex.direct.internaltools.tools.freelancer.tool;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerSkill;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.freelancer.model.IntToolFreelancerSkill;

import static ru.yandex.direct.core.entity.freelancer.model.FreelancerSkill.allFreelancerSkills;

@Tool(
        name = "Список навыков фрилансеров",
        label = "freelancer_skills_list",
        description = "Навыки фрилансеров захардкожены в коде Java. Добавлять, помечать устаревшими и редактировать названия существующих можно только через заведение тикета в https://st.yandex-team.ru/DIRECT",
        consumes = IntToolFreelancerSkill.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.FREELANCER)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.MANAGER,
        InternalToolAccessRole.SUPPORT})
@ParametersAreNonnullByDefault
public class FreelancerSkillShowTool extends MassInternalTool<IntToolFreelancerSkill, IntToolFreelancerSkill> {

    @Override
    protected List<IntToolFreelancerSkill> getMassData(IntToolFreelancerSkill intToolNewSkill) {
        return getMassData();
    }

    @Override
    protected List<IntToolFreelancerSkill> getMassData() {
        return StreamEx.of(allFreelancerSkills())
                .map(this::toIntToolFreelancerSkillCode)
                .toList();
    }

    private IntToolFreelancerSkill toIntToolFreelancerSkillCode(FreelancerSkill freelancerSkill) {
        return new IntToolFreelancerSkill()
                .withSkillId(freelancerSkill.getSkillId())
                .withSkillCode(freelancerSkill.getSkillCode())
                .withSkillName(freelancerSkill.getDescription());
    }
}
