package ru.yandex.direct.internaltools.tools.goodscampaign;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.uac.service.EcomDomainsService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.goodscampaign.container.EditMarketplacesDomainsInfo;
import ru.yandex.direct.internaltools.tools.goodscampaign.model.EditMarketplacesDomainsParameters;
import ru.yandex.direct.internaltools.tools.goodscampaign.model.MarketplaceDomainAction;

import static ru.yandex.direct.common.db.PpcPropertyNames.MARKETPLACE_DOMAINS;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.parseCommaSeparatedString;

@Tool(
        name = "Редактировать список маркетплейсов",
        label = "edit_marketplaces_domains_tool",
        description = "Редактировать список маркетплейсов",
        consumes = EditMarketplacesDomainsParameters.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.ECOM)
@Action(InternalToolAction.EXECUTE)
@AccessGroup({InternalToolAccessRole.MANAGER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class EditMarketplacesDomainsTool
        extends MassInternalTool<EditMarketplacesDomainsParameters, EditMarketplacesDomainsInfo> {

    @Autowired
    PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    EcomDomainsService ecomDomainsService;

    @Override
    protected List<EditMarketplacesDomainsInfo> getMassData(EditMarketplacesDomainsParameters parameter) {
        var currentDomains = getDomains();
        var domainsToEdit = parseCommaSeparatedString(parameter.getDomains());
        var mainMirrorsByDomains = EntryStream.of(ecomDomainsService.toMainMirrors(domainsToEdit))
                .values()
                .nonNull()
                .toList();
        Set<String> resultDomainList = new HashSet<>(currentDomains);
        if (!mainMirrorsByDomains.isEmpty()) {
            if (parameter.getAction() == MarketplaceDomainAction.ADD) {
                resultDomainList.addAll(mainMirrorsByDomains);
            }
            if (parameter.getAction() == MarketplaceDomainAction.DELETE) {
                mainMirrorsByDomains.forEach(resultDomainList::remove);
            }
            ppcPropertiesSupport.get(MARKETPLACE_DOMAINS).set(resultDomainList);
        }
        return StreamEx.of(resultDomainList)
                .map(EditMarketplacesDomainsInfo::new)
                .toList();
    }

    @Override
    public List<EditMarketplacesDomainsInfo> getMassData() {
        return StreamEx.of(getDomains())
                .map(EditMarketplacesDomainsInfo::new)
                .toList();
    }

    private Set<String> getDomains() {
        return ppcPropertiesSupport.get(MARKETPLACE_DOMAINS).getOrDefault(Collections.emptySet());
    }

}
