package ru.yandex.direct.internaltools.tools.goodscampaign.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class EditMarketplacesDomainsParameters extends InternalToolParameter {
    @TextArea
    @Input(label = "Список доменов маркетплейсов", description = "должны быть отделены друг от друга запятой или " +
            "любым whitespace символом, протокол обязателен", required = true)
    private String domains;

    @Input(label = "Действие", required = true)
    private MarketplaceDomainAction action;

    public String getDomains() {
        return domains;
    }

    public MarketplaceDomainAction getAction() {
        return action;
    }

    public EditMarketplacesDomainsParameters withDomains(String domains, MarketplaceDomainAction action) {
        this.domains = domains;
        this.action = action;
        return this;
    }

}
