package ru.yandex.direct.internaltools.tools.hiddenusers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolProcessingResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.hiddenusers.container.MarkUsersAsHiddenInfo;
import ru.yandex.direct.internaltools.tools.hiddenusers.model.MarkUsersAsHiddenParameters;

import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.parseLogins;

@Tool(
        name = "Сделать пользователей тестовыми",
        label = "mark_users_as_hidden",
        description = "Для указанного списка логинов проставляет флаг тестового пользователя (users.hidden = 'Yes'), чтобы пользователи не попадали под удалялки и чистилки",
        consumes = MarkUsersAsHiddenParameters.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.TESTING)
@Action(InternalToolAction.SET)
@AccessGroup({InternalToolAccessRole.MANAGER, InternalToolAccessRole.SUPERREADER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class MarkUsersAsHiddenTool extends MassInternalTool<MarkUsersAsHiddenParameters, MarkUsersAsHiddenInfo> {

    private final UserService userService;

    @Autowired
    public MarkUsersAsHiddenTool(UserService userService) {
        this.userService = userService;
    }

    @Override
    public List<MarkUsersAsHiddenInfo> getMassData(MarkUsersAsHiddenParameters parameter) {
        Set<String> logins = parseLogins(parameter.getLogins());
        List<String> processedLogins = userService.massSetHidden(logins);

        List<MarkUsersAsHiddenInfo> result = new ArrayList<>();
        if (processedLogins.size() != logins.size()) {
            logins.removeAll(processedLogins);
            result.add(new MarkUsersAsHiddenInfo()
                    .withLogins(new ArrayList<>(logins))
                    .withResult(InternalToolProcessingResult.LOGIN_NOT_FOUND)
            );
        }
        if (!processedLogins.isEmpty()) {
            result.add(new MarkUsersAsHiddenInfo()
                    .withLogins(processedLogins)
                    .withResult(InternalToolProcessingResult.OK)
            );
        }

        return result;
    }
}
