package ru.yandex.direct.internaltools.tools.hiddenusers.container;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.internaltools.core.enums.InternalToolProcessingResult;

@ParametersAreNonnullByDefault
public class MarkUsersAsHiddenInfo {

    @JsonProperty("Логины")
    public String logins;

    @JsonProperty("Результат")
    @Enrich(InternalToolDetailKey.HIGHLIGHT)
    public InternalToolProcessingResult result;


    public String getLogins() {
        return logins;
    }

    public InternalToolProcessingResult getResult() {
        return result;
    }

    public MarkUsersAsHiddenInfo withLogins(List<String> logins) {
        this.logins = String.join(", ", logins);
        return this;
    }

    public MarkUsersAsHiddenInfo withLogins(String logins) {
        this.logins = logins;
        return this;
    }


    public MarkUsersAsHiddenInfo withResult(InternalToolProcessingResult result) {
        this.result = result;
        return this;
    }
}
