package ru.yandex.direct.internaltools.tools.hourglass;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.hourglass.client.HourglassClient;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalToolWithoutParam;
import ru.yandex.direct.internaltools.tools.hourglass.container.SchedulerInstanceInfo;

@Tool(
        name = "Список инстансов шедулера",
        label = "hourglass_list_instances",
        description = "Отображает текущий список зарегистрированных в БД инстансов\n" +
                "Readme по ydb и примеры запросов - https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/README.md",
        consumes = InternalToolParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.HOURGLASS)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.SUPERREADER, InternalToolAccessRole.DEVELOPER})
public class HourglassListActiveInstancesTool extends MassInternalToolWithoutParam<SchedulerInstanceInfo> {

    private final HourglassClient hourglassClient;

    @Autowired
    public HourglassListActiveInstancesTool(HourglassClient hourglassClient) {
        this.hourglassClient = hourglassClient;
    }

    @Override
    protected List<SchedulerInstanceInfo> getMassData() {
        return hourglassClient.getSchedulers()
                .stream()
                .map(SchedulerInstanceInfo::new)
                .collect(Collectors.toList());
    }

}
