package ru.yandex.direct.internaltools.tools.hourglass;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.hourglass.client.HourglassClient;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.hourglass.container.JobInfo;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class JobNamesPreprocessor implements InternalToolInputPreProcessor<String> {

    private final HourglassClient hourglassClient;

    public JobNamesPreprocessor(HourglassClient hourglassClient) {
        this.hourglassClient = hourglassClient;
    }

    private Set<String> getJobNames() {
        Set<String> jobs = getJobNamesForHourglassClient(hourglassClient);
        return jobs;
    }

    private Set<String> getJobNamesForHourglassClient(HourglassClient hourglassClient) {
        return hourglassClient.getTasks()
                .stream()
                .map(JobInfo::new)
                .map(JobInfo::getName)
                .collect(Collectors.toSet());
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> jobNamesToChoose = new ArrayList<>();
        List<String> jobNames = getJobNames().stream().sorted().collect(Collectors.toList());
        jobNamesToChoose.add(null);
        jobNamesToChoose.addAll(jobNames);
        return inputBuilder
                .withDefaultValue(null)
                .withAllowedValues(jobNamesToChoose)
                .addValidator(inSet(ImmutableSet.<String>builder().addAll(jobNames).build()));
    }
}
