package ru.yandex.direct.internaltools.tools.hourglass.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.hourglass.storage.Job;

public class JobInfo {

    private String id;
    private String name;
    private String description;
    private String state;

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty("Название")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("Параметры")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty("Состояние")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public JobInfo(Job job) {
        this(job.primaryId().toString(), job.taskId().name(), job.taskId().param(), job.jobStatus().toString());
    }

    public JobInfo(String id, String name, String description, String state) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.state = state;
    }

}
