package ru.yandex.direct.internaltools.tools.hourglass.container;

public enum PauseOption {
    PAUSE("Остановить джобу (прервать, если выполняется, и больше не запускать)"),
    UNPAUSE("Снять джобу с паузы");

    private String optionName;

    PauseOption(String optionName) {
        this.optionName = optionName;
    }

    public String value() {
        return optionName;
    }

    public static PauseOption fromValue(String stringOption) {
        for (var c : PauseOption.values()) {
            if (c.optionName.equals(stringOption)) {
                return c;
            }
        }
        throw new IllegalArgumentException("Unknown pause option " + stringOption);
    }
}
