package ru.yandex.direct.internaltools.tools.hourglass.container;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.hourglass.JobNamesPreprocessor;

public class RunJobParameter extends InternalToolParameter {

    public static final String JOB_ID_NAME = "Id параметра запуска (all чтобы запустить все джобы с выбранным классом)";

    @Input(label = "Название джобы", processors = JobNamesPreprocessor.class)
    @Select(preprocessed = true)
    private String jobName;

    @Input(label = JOB_ID_NAME, required = false)
    private String jobParametersId;

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobParametersId() {
        return jobParametersId.trim();
    }

    public void setJobParametersId(String jobParametersId) {
        this.jobParametersId = jobParametersId;
    }

    @Override
    public String toString() {
        return "RunJobParameter{" +
                "jobName='" + jobName + '\'' +
                ", jobParametersId='" + jobParametersId + '\'' +
                '}';
    }
}
