package ru.yandex.direct.internaltools.tools.hourglass.container;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import ru.yandex.direct.hourglass.client.SchedulerInstance;

import static ru.yandex.direct.internaltools.tools.hourglass.container.SchedulerInstanceInfo.INSTANCE_META_FIELD;
import static ru.yandex.direct.internaltools.tools.hourglass.container.SchedulerInstanceInfo.INSTANCE_NAME_FIELD;
import static ru.yandex.direct.internaltools.tools.hourglass.container.SchedulerInstanceInfo.LAST_CHECKIN_FIELD;
import static ru.yandex.direct.internaltools.tools.hourglass.container.SchedulerInstanceInfo.VERSION_FIELD;

@JsonPropertyOrder({INSTANCE_NAME_FIELD, LAST_CHECKIN_FIELD, INSTANCE_META_FIELD, VERSION_FIELD})
@ParametersAreNonnullByDefault
public class SchedulerInstanceInfo {
    static final String INSTANCE_NAME_FIELD = "Название инстанса";
    static final String LAST_CHECKIN_FIELD = "Последний check-in";
    static final String INSTANCE_META_FIELD = "Дополнительная информация";
    static final String VERSION_FIELD = "Версия инстанса";

    private final String instanceName;
    private final LocalDateTime lastCheckin;
    private final String version;
    private final String instanceMeta;

    public SchedulerInstanceInfo(SchedulerInstance schedulerInfo) {
        this(schedulerInfo.getInstanceId().toString(), schedulerInfo.getHeartbeatTime(),
                schedulerInfo.getVersion(), schedulerInfo.getInstanceMeta());
    }

    public SchedulerInstanceInfo(String instanceName, Instant lastCheckin,
                                 String version, String instanceMeta) {
        this.instanceName = instanceName;
        this.lastCheckin = LocalDateTime.ofInstant(lastCheckin, ZoneId.systemDefault());
        this.version = version;
        this.instanceMeta = instanceMeta;
    }

    @JsonProperty(INSTANCE_NAME_FIELD)
    public String getInstanceName() {
        return instanceName;
    }

    @JsonProperty(VERSION_FIELD)
    public String getInstanceVersion() {
        return version;
    }

    @JsonProperty(LAST_CHECKIN_FIELD)
    public LocalDateTime getLastCheckin() {
        return lastCheckin;
    }

    @JsonProperty(INSTANCE_META_FIELD)
    public String getInstanceMeta() {
        return instanceMeta;
    }
}
