package ru.yandex.direct.internaltools.tools.idm.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IdmGroupAddParameters extends InternalToolParameter {


    public static final String ID_PROP_NAME = "idmGroupId";
    private static final String MANAGER = "manager";
    public static final String ROLE_NAME_PROP_NAME = "Требующаяся роль";


    @NumericId
    @Input(label = ID_PROP_NAME, required = true)
    private Long id;

    @Text
    @Select(choices = {MANAGER}, defaultValue = MANAGER)
    @Input(label = ROLE_NAME_PROP_NAME, required = true)
    private String roleName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

}
