package ru.yandex.direct.internaltools.tools.idm.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IdmGroupMemberParameters extends InternalToolParameter {
    public static final String ID_PROP_NAME = "idmGroupId";
    public static final String LOGIN_PROP_NAME = "Паспортный логин внутреннего пользователя";
    public static final String OPERATION_PROP_NAME = "Операция";
    public static final String SHOW_OPERATION = "Отфильтровать список по пользователю и/или группе";
    public static final String ADD_OPERATION = "Добавить пользователя в группу";
    public static final String DELETE_OPERATION = "Удалить пользователя из группы";
    @Text
    @Input(label = LOGIN_PROP_NAME, required = false)
    private String login;

    @NumericId
    @Input(label = ID_PROP_NAME, required = false)
    private Long idmGroupId;
    @Text
    @Select(choices = {SHOW_OPERATION, ADD_OPERATION, DELETE_OPERATION}, defaultValue = SHOW_OPERATION)
    @Input(label = OPERATION_PROP_NAME, required = true)
    private String operation;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getIdmGroupId() {
        return idmGroupId;
    }

    public void setIdmGroupId(Long idmGroupId) {
        this.idmGroupId = idmGroupId;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}
