package ru.yandex.direct.internaltools.tools.idm.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IdmGroupRoleParameters extends InternalToolParameter {
    public static final String ID_PROP_NAME = "idmGroupId";
    public static final String CLIENT_ID_PROP_NAME = "ClientID клиента";
    public static final String OPERATION_PROP_NAME = "Операция";
    public static final String SHOW_OPERATION = "Отфильтровать список по клиенту и/или группе";
    public static final String ADD_OPERATION = "Дать группе права на доступ к материалам клиента";
    public static final String DELETE_OPERATION = "Отозвать у группы права на доступ к материалам клиента";
    @Text
    @Input(label = CLIENT_ID_PROP_NAME, required = false)
    private Long clientId;

    @NumericId
    @Input(label = ID_PROP_NAME, required = false)
    private Long idmGroupId;
    @Text
    @Select(choices = {SHOW_OPERATION, ADD_OPERATION, DELETE_OPERATION}, defaultValue = SHOW_OPERATION)
    @Input(label = OPERATION_PROP_NAME, required = true)
    private String operation;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Long getIdmGroupId() {
        return idmGroupId;
    }

    public void setIdmGroupId(Long idmGroupId) {
        this.idmGroupId = idmGroupId;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}
