package ru.yandex.direct.internaltools.tools.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class InternalAdsBlockUserParameter extends InternalToolParameter {
    @Text
    @Input(label = "Логин")
    private String login;

    @Text
    @Input(label = "ClientId")
    private Long clientId;

    public String getLogin() {
        return login;
    }

    public Long getClientId() {
        return clientId;
    }

    public InternalAdsBlockUserParameter withLogin(String login) {
        this.login = login;
        return this;
    }

    public InternalAdsBlockUserParameter withClientId(Long name) {
        this.clientId = name;
        return this;
    }
}
