package ru.yandex.direct.internaltools.tools.internalads.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@ParametersAreNonnullByDefault
public class InternalToolsInternalAdsPrivilegedUser {
    @JsonProperty("ClientID")
    private long clientId;

    @JsonProperty("Логин")
    private String login;

    @JsonProperty("ФИО")
    private String fio;

    @JsonProperty("Заблокирован")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private boolean blocked;

    public long getClientId() {
        return clientId;
    }

    public InternalToolsInternalAdsPrivilegedUser withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public InternalToolsInternalAdsPrivilegedUser withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getFio() {
        return fio;
    }

    public InternalToolsInternalAdsPrivilegedUser withFio(String fio) {
        this.fio = fio;
        return this;
    }

    public boolean isBlocked() {
        return blocked;
    }

    public InternalToolsInternalAdsPrivilegedUser withBlocked(boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    @Override
    public String toString() {
        return "InternalToolsInternalAdsPrivilegedUser{" +
                "clientId=" + clientId +
                ", login='" + login + '\'' +
                ", fio='" + fio + '\'' +
                ", blocked=" + blocked +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalToolsInternalAdsPrivilegedUser that = (InternalToolsInternalAdsPrivilegedUser) o;
        return clientId == that.clientId &&
                blocked == that.blocked &&
                Objects.equals(login, that.login) &&
                Objects.equals(fio, that.fio);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, login, fio, blocked);
    }
}
