package ru.yandex.direct.internaltools.tools.internalads.tool;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.client.model.ClientWithUsers;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.internalads.model.InternalAdsBlockUserParameter;
import ru.yandex.direct.internaltools.tools.internalads.model.InternalToolsInternalAdsPrivilegedUser;
import ru.yandex.direct.rbac.RbacRole;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Tool(
        name = "Заблокировать роль пользователя внутренней рекламы (центральный маркетинг)",
        label = "internal_ads_block_user",
        description = "Блокировка пользователей внутренней рекламы, котороые создавались не через idm",
        consumes = InternalAdsBlockUserParameter.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.INTERNAL_ADS)
@Action(InternalToolAction.UPDATE)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class InternalAdsBlockUserTool extends MassInternalTool<InternalAdsBlockUserParameter,
        InternalToolsInternalAdsPrivilegedUser> {

    private final ClientService clientService;

    @Autowired
    public InternalAdsBlockUserTool(
            ClientService clientService) {
        this.clientService = clientService;
    }

    @Override
    public List<InternalToolsInternalAdsPrivilegedUser> getMassData(InternalAdsBlockUserParameter parameter) {
        //todo:  пока мы просто возрващаем список администраторов внутренней рекламы. Нужно добавить их блокировку.
        // (DIRECT-100078)
        //нужно уметь блокировать только клиентов не привязанных к стафу. остальные блокируются через idm

        List<ClientWithUsers> clientsWithUsers = clientService.getClientsWithUsersByRole(RbacRole.INTERNAL_AD_ADMIN);

        return mapList(clientsWithUsers,
                client -> {
                    User singleUser = getAndCheckSingleUser(client);
                    return new InternalToolsInternalAdsPrivilegedUser()
                            .withClientId(client.getClientId())
                            .withFio(singleUser.getFio())
                            .withLogin(singleUser.getLogin())
                            .withBlocked(singleUser.getStatusBlocked());
                }
        );
    }

    private static User getAndCheckSingleUser(ClientWithUsers clientWithUsers) {
        return clientWithUsers.getUsers().stream().findFirst()
                .orElseThrow(() -> new IllegalArgumentException("too many reps for product (expecting exactly one). " +
                        "Product clientId: " + clientWithUsers.getClientId().toString()));
    }
}
