package ru.yandex.direct.internaltools.tools.iscpdpaused;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.iscpdpaused.model.IsCpdPausedUpdateParameters;
import ru.yandex.direct.internaltools.tools.iscpdpaused.model.IsCpdPausedUpdateResult;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.isStringWithValidLongIds;

@Tool(
        name = "Флаг кампаний is_cpd_paused",
        label = "is_cpd_paused_update",
        description = "Просмотр кампаний с флагом is_cpd_paused и его обновление",
        consumes = IsCpdPausedUpdateParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.CPM)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class IsCpdPausedUpdateTool extends MassInternalTool<IsCpdPausedUpdateParameters, IsCpdPausedUpdateResult> {

    private final ShardHelper shardHelper;
    private final CampaignRepository campaignRepository;

    public IsCpdPausedUpdateTool(ShardHelper shardHelper,
                                 CampaignRepository campaignRepository) {
        this.shardHelper = shardHelper;
        this.campaignRepository = campaignRepository;
    }

    @Override
    protected List<IsCpdPausedUpdateResult> getMassData(IsCpdPausedUpdateParameters parameter) {
        shardHelper.groupByShard(getLongIdsFromString(parameter.getCampaignIds()), ShardKey.CID)
                .forEach((shard, cids) ->
                        campaignRepository.updateCampaignsIsCpdPaused(shard, cids, parameter.getState()));
        return getMassData();
    }

    @Override
    protected List<IsCpdPausedUpdateResult> getMassData() {
        return shardHelper.dbShards().stream()
                .flatMap(shard -> campaignRepository.getCampaignsWithIsCpdPaused(shard).stream())
                .map(campaign -> new IsCpdPausedUpdateResult()
                        .withId(campaign.getId())
                        .withName(campaign.getName())
                        .withStartDate(campaign.getStartTime())
                        .withFinishDate(campaign.getFinishTime()))
                .collect(toList());
    }

    @Override
    public ValidationResult<IsCpdPausedUpdateParameters, Defect> validate(
            IsCpdPausedUpdateParameters parameter) {
        ItemValidationBuilder<IsCpdPausedUpdateParameters, Defect> validationBuilder =
                ItemValidationBuilder.of(parameter);
        validationBuilder
                .item(parameter.getCampaignIds(), "campaignIds")
                .check(isStringWithValidLongIds(1));
        return validationBuilder.getResult();
    }
}
