package ru.yandex.direct.internaltools.tools.iscpdpaused.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class IsCpdPausedUpdateParameters extends InternalToolParameter {
    @TextArea
    @Input(label = "Номера кампаний (cid'ы):", description = "номера кампаний должны быть отделены друг от друга " +
            "запятой или любым whitespace символом")
    private String campaignIds;

    @Input(label = "включить is_cpd_paused")
    @CheckBox(checked = true)
    private Boolean state;

    public String getCampaignIds() {
        return campaignIds;
    }

    public IsCpdPausedUpdateParameters withCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public Boolean getState() {
        return state;
    }

    public IsCpdPausedUpdateParameters withState(Boolean state) {
        this.state = state;
        return this;
    }
}
