package ru.yandex.direct.internaltools.tools.measurers;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.measurers.repository.CampMeasurersRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.measurers.model.CpmCampOperationInfo;
import ru.yandex.direct.internaltools.tools.measurers.model.CpmCampToolParameter;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.isStringWithValidLongIds;

@Tool(
        name = "Включить MOAT на кампанию",
        label = "enable_moat",
        description = "Позволяет включить верификатор MOAT на выбранной кампании",
        consumes = CpmCampToolParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.CPM)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class EnableMoatTool extends MassInternalTool<CpmCampToolParameter, CpmCampOperationInfo> {
    private final ShardHelper shardHelper;
    private final CampMeasurersRepository campMeasurersRepository;

    public EnableMoatTool(ShardHelper shardHelper, CampMeasurersRepository campMeasurersRepository) {
        this.shardHelper = shardHelper;
        this.campMeasurersRepository = campMeasurersRepository;
    }

    @Override
    protected List<CpmCampOperationInfo> getMassData(CpmCampToolParameter parameter) {
        shardHelper.groupByShard(getLongIdsFromString(parameter.getCampaignIds()), ShardKey.CID)
                        .forEach((shard, list) -> campMeasurersRepository.enableMoat(shard, list));
        return StreamEx.of(getLongIdsFromString(parameter.getCampaignIds()))
                .map(cid -> new CpmCampOperationInfo()
                        .setId(cid)
                )
                .toList();
    }

    @Override
    public ValidationResult<CpmCampToolParameter, Defect> validate(
            CpmCampToolParameter parameter) {
        ItemValidationBuilder<CpmCampToolParameter, Defect> validationBuilder =
                ItemValidationBuilder.of(parameter);
        validationBuilder
                .item(parameter.getCampaignIds(), "campaignIds")
                .check(isStringWithValidLongIds(1));
        return validationBuilder.getResult();
    }
}
