package ru.yandex.direct.internaltools.tools.minpayab;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.minpayab.model.ABParameter;

import static ru.yandex.direct.common.db.PpcPropertyNames.MIN_PAY_AB_DISTRIBUTION;

@Tool(
        name = "MIN_PAY: конфигурация А/Б эксперимента",
        label = "min_pay_ab",
        description = "В поле для ввода напишите \"сумма в рублях - процент\" по одному значению суммы на строчку.\n" +
                "Например:\n\"100 - 40\n200 - 60\".\n" +
                "Сумма всех процентов должна быть равна 100, проценты должны быть положительными.",
        consumes = ABParameter.class,
        type = InternalToolType.WRITER)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.EXPERIMENT)
@AccessGroup({InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class MinPayABTool extends BaseABTool {

    @Autowired
    public MinPayABTool(PpcPropertiesSupport ppcPropertiesSupport) {
        super(ppcPropertiesSupport);
    }

    @Override
    PpcPropertyName<String> getProperty() {
        return MIN_PAY_AB_DISTRIBUTION;
    }

    @Override
    Comparator<String[]> sortingComparator() {
        return Comparator.comparing(a -> Integer.valueOf(a[0]));
    }

    @Override
    String getMatchingRegexp() {
        return "^\\d+\\s*+-\\s*+\\d+$";
    }

    @Override
    String objDesc(BaseABTool.DistObject obj) {
        return String.format("%s р. - %d%%", obj.getSum(), obj.getPercent());
    }
}
