package ru.yandex.direct.internaltools.tools.minpayab;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.minpayab.model.ABParameter;

import static ru.yandex.direct.common.db.PpcPropertyNames.PAYMENT_SUGGEST_BLOCK_AB;


@Tool(
        name = "Новый воркфлоу оплаты: конфигурация А/Б эксперимента",
        label = "new_payment_workflow",
        description = "В поле для ввода напишите \"название блока - процент\" по одному значению суммы на строчку.\n" +
                "Названия блоков должны быть из набора (autopay, autopay_opt_out, autopay_save, autooverdraft, none)" +
                "\nНапример:\n\"autopay - 40\nautooverdraft - 60\".\n" +
                "Сумма всех процентов должна быть равна 100, проценты должны быть положительными.",
        consumes = ABParameter.class,
        type = InternalToolType.WRITER)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.EXPERIMENT)
@AccessGroup({InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class PaymentWorkflowABTool extends BaseABTool {

    @Autowired
    PaymentWorkflowABTool(PpcPropertiesSupport ppcPropertiesSupport) {
        super(ppcPropertiesSupport);
    }

    @Override
    PpcPropertyName<String> getProperty() {
        return PAYMENT_SUGGEST_BLOCK_AB;
    }

    @Override
    String getMatchingRegexp() {
        return "^(autopay|autopay_opt_out|autopay_save|autooverdraft|none)\\s*+-\\s*+\\d+$";
    }

    @Override
    String objDesc(DistObject obj) {
        return String.format("%s - %d%%", obj.getSum(), obj.getPercent());
    }

    @Override
    Comparator<String[]> sortingComparator() {
        return Comparator.comparing(a -> a[0]);
    }
}
