package ru.yandex.direct.internaltools.tools.mobileapps.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateMobileContentParameters extends InternalToolParameter {

    @Text
    @Input(label = "Логин")
    private String login;

    @Text
    @Input(label = "Идентификаторы мобильного контента (mobile_content_id)", required = false)
    private String mobileContentIds;

    @Text
    @Input(label = "Идентификаторы баннеров (bid)", required = false)
    private String bids;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getMobileContentIds() {
        return mobileContentIds;
    }

    public void setMobileContentIds(String mobileContentIds) {
        this.mobileContentIds = mobileContentIds;
    }

    public String getBids() {
        return bids;
    }

    public void setBids(String bids) {
        this.bids = bids;
    }
}
