package ru.yandex.direct.internaltools.tools.mobileapps.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateMobileContentResult {

    @JsonProperty("Результат выполнения")
    private String result;

    @JsonProperty("Шард")
    private int shard;

    @JsonProperty("Обновлено записей")
    private int dbRes;

    public String getResult() {
        return result;
    }

    public UpdateMobileContentResult withResult(String result) {
        this.result = result;
        return this;
    }

    public int getShard() {
        return shard;
    }

    public UpdateMobileContentResult withShard(int shard) {
        this.shard = shard;
        return this;
    }

    public int getDbRes() {
        return dbRes;
    }

    public UpdateMobileContentResult withDbRes(int dbRes) {
        this.dbRes = dbRes;
        return this;
    }
}
