package ru.yandex.direct.internaltools.tools.mobileapps.tool;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.mobilecontent.repository.MobileContentFetchQueueRepository;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.mobileapps.model.FetchMobileContentFromStoreParameters;
import ru.yandex.direct.internaltools.tools.mobileapps.model.FetchMobileContentFromStoreResult;

@Tool(
        name = "Извлечь данные о мобильных приложениях из store",
        label = "fetch_mobile_content_from_store",
        description = "Ручное извлечение данных о приложении из store",
        consumes = FetchMobileContentFromStoreParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.MOBILE_CONTENT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class FetchMobileContentFromStoreTool
        extends MassInternalTool<FetchMobileContentFromStoreParameters, FetchMobileContentFromStoreResult> {

    private MobileContentFetchQueueRepository mobileContentFetchQueueRepository;

    public FetchMobileContentFromStoreTool(MobileContentFetchQueueRepository mobileContentFetchQueueRepository) {
        this.mobileContentFetchQueueRepository = mobileContentFetchQueueRepository;
    }

    @Override
    protected List<FetchMobileContentFromStoreResult> getMassData(FetchMobileContentFromStoreParameters parameter) {
        List<String> urls = StreamEx.of(parameter.getUrls().split("[,\\s]+"))
                .toList();

        mobileContentFetchQueueRepository.addUrls(urls);

        return StreamEx.of(urls)
                .map(url -> new FetchMobileContentFromStoreResult().withUrl(url))
                .toList();
    }
}
