package ru.yandex.direct.internaltools.tools.mobileapps.tool;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;
import ru.yandex.direct.core.entity.mobilecontent.service.UpdateMobileContentService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.mobileapps.model.UpdateMobileContentParameters;
import ru.yandex.direct.internaltools.tools.mobileapps.model.UpdateMobileContentResult;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;

@Tool(
        name = "Ручное обновление данных о мобильном контенте",
        label = "update_mobile_content",
        description = "Ручное обновление данных о мобильном контенте",
        consumes = UpdateMobileContentParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.MOBILE_CONTENT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPPORT})
@ParametersAreNonnullByDefault
public class UpdateMobileContentTool extends MassInternalTool<UpdateMobileContentParameters, UpdateMobileContentResult> {

    private final UpdateMobileContentService updateMobileContentService;

    public UpdateMobileContentTool(UpdateMobileContentService updateMobileContentService) {
        this.updateMobileContentService = updateMobileContentService;
    }

    @Override
    protected List<UpdateMobileContentResult> getMassData(UpdateMobileContentParameters parameter) {
        List<String> logins = StreamEx.of(parameter.getLogin().split("[,\\s]+"))
                .toList();
        List<Long> mobileContentIds = Strings.isBlank(parameter.getMobileContentIds()) ? emptyList() :
                StreamEx.of(parameter.getMobileContentIds().split("[\\D]+"))
                        .map(Long::parseLong)
                        .toList();
        List<Long> bannersIds = Strings.isBlank(parameter.getBids()) ? emptyList() :
                StreamEx.of(parameter.getBids().split("[\\D]+"))
                        .map(Long::parseLong)
                        .toList();

        Map<Integer, List<AppliedChanges<MobileContent>>> appliedChangesByShard =
                updateMobileContentService.process(logins, mobileContentIds, bannersIds);

        return EntryStream.of(appliedChangesByShard)
                .map(e ->
                        new UpdateMobileContentResult()
                                .withResult(e.getValue().isEmpty() ? "Нет данных для обновления" : "OK")
                                .withShard(e.getKey())
                                .withDbRes(e.getValue().size()))
                .toList();
    }
}
