package ru.yandex.direct.internaltools.tools.moderationdiags;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderationdiag.repository.ModerationDiagRepository;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.moderationdiags.model.UpdateModerationDiagsBanIsProhibitedParams;
import ru.yandex.direct.internaltools.tools.moderationdiags.model.UpdateModerationDiagsBanIsProhibitedResult;

@Tool(
        name = "Изменение критичности причин отклонения",
        label = "update_moderation_diags_unban_is_prohibited_tool",
        description = "Изменяет критичность для причин отлонения модерацией."
                + "Для подробностей см. описание поля ppcdict.moderate_diags.unban_is_prohibited.",
        consumes = UpdateModerationDiagsBanIsProhibitedParams.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.MODERATE)
@Action(InternalToolAction.UPDATE)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.PLACER})
@ParametersAreNonnullByDefault
public class UpdateModerationDiagsUnbanIsProhibitedTool extends MassInternalTool<UpdateModerationDiagsBanIsProhibitedParams, UpdateModerationDiagsBanIsProhibitedResult> {

    private final ModerationDiagRepository moderationDiagRepository;

    @Autowired
    public UpdateModerationDiagsUnbanIsProhibitedTool(ModerationDiagRepository moderationDiagRepository) {
        this.moderationDiagRepository = moderationDiagRepository;
    }

    @Override
    public List<UpdateModerationDiagsBanIsProhibitedResult> getMassData(UpdateModerationDiagsBanIsProhibitedParams updateModerationDiagsBanIsProhibitedParams) {
        Set<Long> moderatationDiagIds = StreamEx.of(updateModerationDiagsBanIsProhibitedParams.getModerationDiagsIds().split(","))
                .map(String::trim)
                .map(Long::parseLong)
                .toSet();
        boolean setUnbanIsProhibited = updateModerationDiagsBanIsProhibitedParams.getSetBanIsProhibited();

        moderationDiagRepository.updateUnbanIsProhibited(moderatationDiagIds, setUnbanIsProhibited);

        return StreamEx.of(moderationDiagRepository.fetch(moderatationDiagIds))
                .map(moderationDiag -> new UpdateModerationDiagsBanIsProhibitedResult(moderationDiag.getId(),
                        moderationDiag.getUnbanIsProhibited()))
                .toList();
    }
}
