package ru.yandex.direct.internaltools.tools.moderationdiags.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class UpdateModerationDiagsBanIsProhibitedResult {

    @JsonProperty("Id причины отклонения")
    private Long moderationDiagId;

    @JsonProperty("Является критичной")
    private Boolean unbanIsProhibited;

    public UpdateModerationDiagsBanIsProhibitedResult(Long moderationDiagId, Boolean unbanIsProhibited) {
        this.moderationDiagId = moderationDiagId;
        this.unbanIsProhibited = unbanIsProhibited;
    }

    public Long getModerationDiagId() {
        return moderationDiagId;
    }

    public Boolean getUnbanIsProhibited() {
        return unbanIsProhibited;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateModerationDiagsBanIsProhibitedResult that = (UpdateModerationDiagsBanIsProhibitedResult) o;
        return Objects.equals(moderationDiagId, that.moderationDiagId) &&
                Objects.equals(unbanIsProhibited, that.unbanIsProhibited);
    }

    @Override
    public int hashCode() {
        return Objects.hash(moderationDiagId, unbanIsProhibited);
    }
}
