package ru.yandex.direct.internaltools.tools.modexport.model;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class UpdateParIdModExportQueueParameters extends InternalToolParameter {
    public static final String CAMPAIGN_IDS_FIELD_NAME = "campaignIds";
    public static final String NEED_DELETE_FIELD_NAME = "Назначить par_id = NULL";

    @TextArea(rows = 4, columns = 40)
    @Input(label = CAMPAIGN_IDS_FIELD_NAME,
            description = "Номера кампаний (cid'ы), могут быть разделены запятыми или любым whitespace символами")
    private String campaignIds;

    @Input(label = "Номер процесса", required = false)
    @NumericId
    private Long parId;

    @Input(label = NEED_DELETE_FIELD_NAME, required = false)
    @CheckBox(checked = false)
    private Boolean needDelete;

    public String getCampaignIds() {
        return campaignIds;
    }

    public UpdateParIdModExportQueueParameters withCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public Long getParId() {
        return parId;
    }

    public UpdateParIdModExportQueueParameters withParId(Long parId) {
        this.parId = parId;
        return this;
    }

    public Boolean getNeedDelete() {
        return needDelete;
    }

    public UpdateParIdModExportQueueParameters withNeedDelete(Boolean needDelete) {
        this.needDelete = needDelete;
        return this;
    }
}
