package ru.yandex.direct.internaltools.tools.modreasons.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.ShardSelect;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class DeleteModReasonsParameters extends InternalToolParameter {
    public static final String SHARD_FIELD_NAME = "шард";
    public static final String CLIENTID_FIELD_NAME = "ClientID";
    public static final String CID_FIELD_NAME = "cid";

    @Input(label = SHARD_FIELD_NAME, required = false)
    @ShardSelect
    private Integer shard;

    @Input(label = CLIENTID_FIELD_NAME)
    @NumericId
    private long clientId;

    @Input(label = CID_FIELD_NAME)
    @NumericId
    private long cid;

    @Nullable
    public Integer getShard() {
        return shard;
    }

    public void setShard(Integer shard) {
        this.shard = shard;
    }

    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public long getCid() {
        return cid;
    }

    public void setCid(long cid) {
        this.cid = cid;
    }
}
