package ru.yandex.direct.internaltools.tools.multicurrency;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalToolWithoutParam;
import ru.yandex.direct.internaltools.tools.multicurrency.container.CurrenciesConstantInfo;

@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.MULTICURRENCY)
@Tool(
        name = "Денежные константы",
        description = "Просмотр значений мультивалютных констант",
        label = "currency_constants",
        type = InternalToolType.REPORT,
        consumes = InternalToolParameter.class
)
public class ListAllCurrenciesConstantsTool extends MassInternalToolWithoutParam<CurrenciesConstantInfo> {
    @Override
    protected List<CurrenciesConstantInfo> getMassData() {
        return Arrays.stream(Currency.class.getDeclaredMethods())
                .sorted(Comparator.comparing(Method::getName))
                .map(CurrenciesConstantInfo::new)
                .collect(Collectors.toList());
    }
}
