package ru.yandex.direct.internaltools.tools.newinterface.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class NewInterfaceAlertValue {
    @JsonProperty("Включена")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean enableAlert;

    @JsonProperty("Русский текст")
    private String alertTextRu;

    @JsonProperty("Английский текст")
    private String alertTextEn;

    @JsonProperty("Список ClientID")
    private String clientIds;

    public NewInterfaceAlertValue(String enableAlert, String alertTextRu, String alertTextEn, String clientIds) {
        this.enableAlert = (enableAlert != null && enableAlert.equals("1"));
        this.alertTextRu = alertTextRu;
        this.alertTextEn = alertTextEn;
        this.clientIds = clientIds;
    }

    public Boolean getEnableAlert() {
        return enableAlert;
    }

    public void setEnableAlert(Boolean enableAlert) {
        this.enableAlert = enableAlert;
    }

    public String getAlertTextRu() {
        return alertTextRu;
    }

    public void setAlertTextRu(String alertTextRu) {
        this.alertTextRu = alertTextRu;
    }

    public String getAlertTextEn() {
        return alertTextEn;
    }

    public void setAlertTextEn(String alertTextEn) {
        this.alertTextEn = alertTextEn;
    }

    public String getClientIds() {
        return clientIds;
    }

    public void setClientIds(String clientIds) {
        this.clientIds = clientIds;
    }
}
