package ru.yandex.direct.internaltools.tools.newinterface.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class NewInterfaceAlertParameters extends InternalToolParameter {

    @Input(label = "Включить плашку-предупреждение")
    @CheckBox(checked = false)
    private Boolean enableAlert;

    @Input(label = "Русский текст предупреждения", required = false)
    private String alertTextRu;

    @Input(label = "Английский текст предупреждения", required = false)
    private String alertTextEn;

    @Input(label = "Список ClientID. Оставь пустым, чтобы показать плашку всем", required = false)
    @TextArea
    private String clientIds;

    public Boolean getEnableAlert() {
        return enableAlert;
    }

    public void setEnableAlert(Boolean enableAlert) {
        this.enableAlert = enableAlert;
    }

    public String getAlertTextRu() {
        return alertTextRu;
    }

    public void setAlertTextRu(String alertTextRu) {
        this.alertTextRu = alertTextRu;
    }

    public String getAlertTextEn() {
        return alertTextEn;
    }

    public void setAlertTextEn(String alertTextEn) {
        this.alertTextEn = alertTextEn;
    }

    public String getClientIds() {
        return clientIds;
    }

    public void setClientIds(String clientIds) {
        this.clientIds = clientIds;
    }
}
