package ru.yandex.direct.internaltools.tools.oneshot;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

import javax.annotation.Nullable;

public class LogviewerUrlUtil {
    private LogviewerUrlUtil() {
        // util class
    }

    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    private static final String LAUNCH_LOG_URL_FORMAT =
            "/logviewer#messages,%s,%s,false,1:100,3,log_time_nanos,trace_id,parent_id,service,direct.oneshot,trace_id,%s";
    private static final String LAUNCH_DATA_LOG_URL_FORMAT =
            "/logviewer#messages,%s,%s,false,1:100,3,log_time_nanos,trace_id,parent_id,service,direct.oneshot,span_id,%d";

    public static String getLaunchDataLogUrl(LocalDateTime launchTime, LocalDateTime finishTime, Long spanId) {
        String dateFrom = formatToLogviewer(getDateFrom(launchTime));
        String dateTo = formatToLogviewer(getDateTo(finishTime).plusHours(1));
        return String.format(LAUNCH_DATA_LOG_URL_FORMAT,
                dateFrom, dateTo, spanId);
    }

    public static String getLaunchLogUrl(LocalDateTime oneshotCreateTime,
                                         Long traceId) {
        String dateFrom = formatToLogviewer(getDateFrom(oneshotCreateTime));
        String dateTo = formatToLogviewer(getDateTo(LocalDateTime.now().plusHours(1)));
        return String.format(LAUNCH_LOG_URL_FORMAT, dateFrom, dateTo, traceId);
    }


    private static LocalDateTime getDateFrom(@Nullable LocalDateTime fromTime) {
        if (fromTime != null) {
            return fromTime;
        }
        return LocalDateTime.now().truncatedTo(ChronoUnit.DAYS);
    }

    static String formatToLogviewer(LocalDateTime date) {
        return date.format(DATE_FORMATTER);
    }

    private static LocalDateTime getDateTo(@Nullable LocalDateTime toTime) {
        if (toTime != null) {
            return toTime;
        }
        return LocalDateTime.now().plus(1, ChronoUnit.DAYS).truncatedTo(ChronoUnit.DAYS);
    }
}
