package ru.yandex.direct.internaltools.tools.oneshot.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.oneshot.OneshotToolsUtil;
import ru.yandex.direct.oneshot.core.entity.oneshot.repository.OneshotLaunchRepository;
import ru.yandex.direct.oneshot.core.entity.oneshot.repository.OneshotRepository;
import ru.yandex.direct.oneshot.core.model.Oneshot;
import ru.yandex.direct.oneshot.core.model.OneshotLaunch;

import static ru.yandex.direct.internaltools.tools.oneshot.launch.OneshotLaunchesTool.SORTING_COMPARATOR;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class OneshotLaunchesSelectProvider implements InternalToolInputPreProcessor<String> {

    private static final String EMPTY_PLACEHOLDER = "";

    private OneshotRepository oneshotRepository;
    private OneshotLaunchRepository oneshotLaunchRepository;

    public OneshotLaunchesSelectProvider(OneshotRepository oneshotRepository,
                                         OneshotLaunchRepository oneshotLaunchRepository) {
        this.oneshotRepository = oneshotRepository;
        this.oneshotLaunchRepository = oneshotLaunchRepository;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        Map<Long, Oneshot> oneshotById = oneshotRepository.getExistingById();
        List<OneshotLaunch> launches =
                oneshotLaunchRepository.getByOneshotIds(oneshotById.keySet());

        List<String> launchesWithClassName = StreamEx.of(launches)
                .sorted(SORTING_COMPARATOR)
                .mapToEntry(OneshotLaunch::getId, OneshotLaunch::getOneshotId)
                .mapValues(oneshotId -> oneshotById.get(oneshotId).getClassName())
                .mapValues(OneshotToolsUtil::cutOneshotClass)
                .mapKeyValue((launchId, className) -> launchId + ": " + className)
                .toList();

        List<String> displayedValues = new ArrayList<>();
        displayedValues.add(EMPTY_PLACEHOLDER);
        displayedValues.addAll(launchesWithClassName);

        return inputBuilder
                .withAllowedValues(displayedValues)
                .addValidator(inSet(ImmutableSet.copyOf(launchesWithClassName)))
                .withDefaultValue(null);
    }
}
